//
//  MCIOChannel.h
//  MCNetComm
//
//  Created by Brent Gulanowski on 22/04/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface MCIOChannel : NSObject {

	id delegate; // weak reference
	
	BOOL useSecureChannel;
}

- (id)delegate;
- (void)setDelegate:(id)object;

- (BOOL)useSecureChannel;
- (void)setUseSecureChannel:(BOOL)flag;

// designated initializer
- (id)initWithDelegate:(id)object;

// All of the following methods must be implemented by subclasses
- (BOOL)open;
- (void)close;
- (void)closeAfterWriting;

- (BOOL)isOpen;
- (NSString *)remotePeerAddress;

- (void)readDataToLength:(CFIndex)length withTimeout:(NSTimeInterval)timeout tag:(long)tag;
- (void)readDataToData:(NSData *)data withTimeout:(NSTimeInterval)timeout tag:(long)tag;
- (void)readDataWithTimeout:(NSTimeInterval)timeout tag:(long)tag;

// timeout and tag are ignored by the file-based channel
- (void) writeData:(NSData *)data withTimeout:(NSTimeInterval)timeout tag:(long)tag;

- (float)progressOfReadReturningTag:(long *)tag bytesDone:(CFIndex *)done total:(CFIndex *)total;
// -progressOfWriteReturningTag: is a noop for file-based channel (until background write thread is implemented)
- (float)progressOfWriteReturningTag:(long *)tag bytesDone:(CFIndex *)done total:(CFIndex *)total;

+ (NSData *) CRLFData; // 0x0D0A
+ (NSData *) CRData; // 0x0D
+ (NSData *) LFData; // 0x0A
+ (NSData *) ZeroData; // 0x00

@end


@interface NSObject (MCIOChannelDelegate)

- (void)onChannel:(MCIOChannel *)aChannel willCloseWithError:(NSError *)error;
- (void)onChannelDidClose:(MCIOChannel *)aChannel;
- (BOOL)onChannelWillOpen:(MCIOChannel *)aChannel;

- (void)onChannel:(MCIOChannel *)aChannel didOpenToHost:(NSString *)host port:(UInt16)port;
- (void)onChannel:(MCIOChannel *)aChannel didOpenToInputFile:(NSString *)inputPath;
- (void)onChannel:(MCIOChannel *)aChannel didOpenToOutputFile:(NSString *)outputPath;

- (void)onChannel:(MCIOChannel *)aChannel didReadData:(NSData*)data withTag:(long)tag;
- (void)onChannel:(MCIOChannel *)aChannel didReadPartialDataOfLength:(CFIndex)partialLength tag:(long)tag;
- (void)onChannel:(MCIOChannel *)aChannel didWriteDataWithTag:(long)tag;

- (BOOL)channelIsServer:(MCIOChannel *)aChannel;

@end
